
#include "DX_VOS_BaseTypes.h"
#include "PLAT_SystemDep.h"
#include "CRYS_Defs.h"
#include "gen.h"
#include "GeneralHwDefs.h"

/************************ Defines ******************************/
#ifndef DX_ARM1176	 
 	 /* SEP ROM length in words and start address */ 	 
   #define  CRYS_SEP_ROM_length		        0x4000
   /* SEP ROM start address */    		 
   #define  CRYS_SEP_ROM_start_address		0xC0010000UL

   /* SEP ROM control address */    		 
   #define  CRYS_SEP_ROM_control_address	0xC0020004UL
#else      
   /* SEP ROM write enabling register address */
   #define  SEP_ROM_BANK_register		      0x80008420UL
   
   /* SEP ROM start address */    		 
   #define  CRYS_SEP_ROM_start_address		0x8000C000UL
   
#ifndef DX_ARM1176_CC5
   /* SEP ROM length in words and start address */ 	 
   #define  CRYS_SEP_ROM_length		        0x2000
#else
   /* SEP ROM length in words and start address */ 	 
   #define  CRYS_SEP_ROM_length		        0x4000
#endif
 
#endif

#define HOST_SC_LOC      0x1100001C
#define HOST_SC_OSC      0x11000004

#define CLK_5MHZ    0x0C
#define CLK_10MHZ   0x20
#define CLK_20MHZ   0x48

/************************ Enums ******************************/


/************************ Typedefs ******************************/


/************************ Global Data ******************************/
#ifndef DX_TST_OS

#ifdef DX_ARM_INTEGRATOR_DEBUG
  /* CRYS_PIC_ROM data */
   static DxUint32_t CRYS_SEP_ROM[] = { 
   										#include "SEP_ROM_image.h"
   									 };

/************* Private function prototype ****************/
void DX_CC_TST_SepRomLoader ( void );
/************************ Public Functions ******************************/

/**
 * @brief This function initializes the CRYS SW for the testing platform.
 *
 *  The function should be called before the CRYS_INIT function.
 *
 * @param[in] - HwBaseAddress the hardware base address.
 
 * @return CRYSError_t - On success CRYS_OK is returned, on failure a
 *                        value MODULE_* as defined in ...
 */

void  CRYS_TST_Init( void )
{
  /* FUNCTION DECLERATIONS */
#ifdef DX_ARM1176 
  /* FUNCTION LOGIC */
  DX_GEN_WriteRegister(0x10000020,0x0000a05f); // Unlock
  DX_GEN_WriteRegister(0x10000014,0xbc5c); /* 5M*/
  DX_GEN_WriteRegister(0x10000020,0x00000000); // lock 
#else
  DX_GEN_WriteRegister(HOST_SC_LOC,0xA05F);
  DX_GEN_WriteRegister(HOST_SC_OSC,CLK_5MHZ);
#endif /* DX_ARM1176 */


#ifdef DX_ARM1176
	DX_GEN_WriteRegister(0x80004100, 0x98fb66d6);/*RKEK0*/
  DX_GEN_WriteRegister(0x80004104, 0x41322da3);/*RKEK1*/
  DX_GEN_WriteRegister(0x80004108, 0xf8481a66);/*RKEK2*/
  DX_GEN_WriteRegister(0x8000410C, 0x1b15d33d);/*RKEK3*/
  DX_GEN_WriteRegister(0x80004110, 0xe4ef3212);/*RKEK4*/
  DX_GEN_WriteRegister(0x80004114, 0xf812a2f5);/*RKEK5*/
  DX_GEN_WriteRegister(0x80004118, 0x54dd28b5);/*RKEK6*/
  DX_GEN_WriteRegister(0x8000411C, 0xd685dd19);/*RKEK7*/
  DX_GEN_WriteRegister(0x80004120, 0X8000afaf);/*ECC */
  DX_GEN_WriteRegister(0x80004124, 0x00000000);/*LCS*/
  DX_GEN_WriteRegister(0x80004128, 0x62CC9EA3);/*SJTAG0*/
  DX_GEN_WriteRegister(0x8000412C, 0x4D56A8DE);/*SJTAG1*/
  DX_GEN_WriteRegister(0x80004130, 0x7CA9A287);/*SJTAG2*/
  DX_GEN_WriteRegister(0x80004134, 0xA5344C91);/*SJTAG3*/
  DX_GEN_WriteRegister(0x80004138, 0xA24F41AD);/*SJTAG4*/
  DX_GEN_WriteRegister(0x8000413C, 0x229345F4);/*SJTAG5*/
  DX_GEN_WriteRegister(0x80004140, 0xD43BE7D7);/*SJTAG6*/
  DX_GEN_WriteRegister(0x80004144, 0xD1A9BBB3);/*SJTAG7*/
  DX_GEN_WriteRegister(0x80004148, 0x000005FA);/*ECC */
											


  DX_GEN_WriteRegister(0x8000414C, 0x84016ba2 );/*OEM0*/
  DX_GEN_WriteRegister(0x80004150, 0x37bccadf );/*OEM1*/
  DX_GEN_WriteRegister(0x80004154, 0x24abae06 );/*OEM2*/
  DX_GEN_WriteRegister(0x80004158, 0x924b737e );/*OEM3*/
  DX_GEN_WriteRegister(0x8000415C, 0xc76754df );/*OEM4*/
  DX_GEN_WriteRegister(0x80004160, 0x5d6523bc );/*OEM5*/
  DX_GEN_WriteRegister(0x80004164, 0xbe5d0932 );/*OEM6*/
  DX_GEN_WriteRegister(0x80004168, 0x7e03e713 );/*OEM7*/
  DX_GEN_WriteRegister(0x8000416C, 0x00007979);/*ECC*/

#else

  DX_GEN_WriteRegister(0xC0020100, 0x98fb66d6);/*RKEK0*/
  DX_GEN_WriteRegister(0xC0020104, 0x41322da3);/*RKEK1*/
  DX_GEN_WriteRegister(0xC0020108, 0xf8481a66);/*RKEK2*/
  DX_GEN_WriteRegister(0xC002010C, 0x1b15d33d);/*RKEK3*/
  DX_GEN_WriteRegister(0xC0020110, 0xe4ef3212);/*RKEK4*/
  DX_GEN_WriteRegister(0xC0020114, 0xf812a2f5);/*RKEK5*/
  DX_GEN_WriteRegister(0xC0020118, 0x54dd28b5);/*RKEK6*/
  DX_GEN_WriteRegister(0xC002011C, 0xd685dd19);/*RKEK7*/
  DX_GEN_WriteRegister(0xC0020120, 0X8000afaf);/*ECC */
  DX_GEN_WriteRegister(0xC0020124, 0x00000000);/*LCS*/
  DX_GEN_WriteRegister(0xC0020128, 0x62CC9EA3);/*SJTAG0*/
  DX_GEN_WriteRegister(0xC002012C, 0x4D56A8DE);/*SJTAG1*/
  DX_GEN_WriteRegister(0xC0020130, 0x7CA9A287);/*SJTAG2*/
  DX_GEN_WriteRegister(0xC0020134, 0xA5344C91);/*SJTAG3*/
  DX_GEN_WriteRegister(0xC0020138, 0xA24F41AD);/*SJTAG4*/
  DX_GEN_WriteRegister(0xC002013C, 0x229345F4);/*SJTAG5*/
  DX_GEN_WriteRegister(0xC0020140, 0xD43BE7D7);/*SJTAG6*/
  DX_GEN_WriteRegister(0xC0020144, 0xD1A9BBB3);/*SJTAG7*/
  DX_GEN_WriteRegister(0xC0020148, 0x000005FA);/*ECC */
											


  DX_GEN_WriteRegister(0xC002014C, 0x84016ba2 );/*OEM0*/
  DX_GEN_WriteRegister(0xC0020150, 0x37bccadf );/*OEM1*/
  DX_GEN_WriteRegister(0xC0020154, 0x24abae06 );/*OEM2*/
  DX_GEN_WriteRegister(0xC0020158, 0x924b737e );/*OEM3*/
  DX_GEN_WriteRegister(0xC002015C, 0xc76754df );/*OEM4*/
  DX_GEN_WriteRegister(0xC0020160, 0x5d6523bc );/*OEM5*/
  DX_GEN_WriteRegister(0xC0020164, 0xbe5d0932 );/*OEM6*/
  DX_GEN_WriteRegister(0xC0020168, 0x7e03e713 );/*OEM7*/
  DX_GEN_WriteRegister(0xC002016C, 0x00007979);/*ECC*/

#endif

  DX_CC_TST_SepRomLoader();   
   
  return;  
   
}/* END OF CRYS_Init */ 
  
#ifndef DX_ARM1176
void DX_CC_TST_SepRomLoader (void)
{
  /* Index variables */   
  DxUint32_t i, k;
   
  /* Loading ROM from SEP_ROM_image.h file */
  k = sizeof(CRYS_SEP_ROM);

  DX_GEN_ROM_WriteRegister(CRYS_SEP_ROM_control_address ,0x80000000); 

	/* Write ROM data  to RAM */		    
  for(i = 0; i <  CRYS_SEP_ROM_length ; i++)	   	   		
  {
    DX_GEN_ROM_WriteRegister(CRYS_SEP_ROM_start_address + 4*i, CRYS_SEP_ROM[i]); 
	
    /*decrese the data size*/
    k= k - 4;
    if(k==0)
    {
      i= CRYS_SEP_ROM_length;
    }
  }   
  DX_GEN_ROM_WriteRegister(CRYS_SEP_ROM_control_address ,0x0); 
  /* reset the SEP*/
  DX_GEN_WriteRegister(GEN_HW_HOST_SEP_SW_RST_REG_ADDR,0x1);    

  return; 									   		   
}

#else

#ifndef DX_ARM1176_CC5

void DX_CC_TST_SepRomLoader (void)
{
  /* Index variables */   
  DxUint32_t i, k,j;
  DxUint32_t  regVal;
   
  /* Loading ROM from SEP_ROM_image.h file */
  k = sizeof(CRYS_SEP_ROM);

  for(i = 0;i < 2; i++)
  {
      /* write bank */
  	  DX_GEN_WriteRegister(SEP_ROM_BANK_register ,i);
  	  
  	  for(j = 0;j < CRYS_SEP_ROM_length / 2;j++)
  	  {
	      DX_GEN_WriteRegister(CRYS_SEP_ROM_start_address + 4*j, CRYS_SEP_ROM[i * 0x1000 + j]); 
  		  k= k - 4;
  		  if(k==0)
      	{
          j= CRYS_SEP_ROM_length;
        	i=4;
        }
  	  }
  }
  
  /* reset the SEP*/
  DX_GEN_WriteRegister(GEN_HW_HOST_SEP_SW_RST_REG_ADDR,0x1); 

  return; 									   		   
}

#else

void DX_CC_TST_SepRomLoader (void)
{
  /* Index variables */   
  DxUint32_t i, k,j;
  DxUint32_t  regVal;
   
  /* Loading ROM from SEP_ROM_image.h file */
  k = sizeof(CRYS_SEP_ROM);

  for(i = 0;i < 4; i++)
  {
      /* write bank */
  	  DX_GEN_WriteRegister(SEP_ROM_BANK_register ,i);
  	  
  	  for(j = 0;j < CRYS_SEP_ROM_length / 4;j++)
  	  {
	      DX_GEN_WriteRegister(CRYS_SEP_ROM_start_address + 4*j, CRYS_SEP_ROM[i * 0x1000 + j]); 
  		  k= k - 4;
  		  if(k==0)
      	{
          j= CRYS_SEP_ROM_length;
        	i=4;
        }
  	  }
  }
  
  /* reset the SEP*/
  DX_GEN_WriteRegister(GEN_HW_HOST_SEP_SW_RST_REG_ADDR,0x1); 

  return; 									   		   
}

#endif //DX_ARM1176_CC5

#endif //DX_ARM1176

#endif // DX_ARM_INTEGRATOR_DEBUG

#else /* DX_TST_OS */

void  CRYS_TST_Init( void )
{
  return;
}

#endif /* DX_TST_OS */
